<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Xhprof
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Xhprof
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Xhprof
 */
class Core_Xhprof_ProfileTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Xhprof_Profile
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Xhprof_Profile;
    }

    /**
     * @covers Core_Xhprof_Profile::setData
     * @covers Core_Xhprof_Profile::getData
     */
    public function testCanSetAndGetData()
    {
        $data = array('bla' => 123);
        $this->_object->setData($data);
        $this->assertEquals($data, $this->_object->getData());
    }

    /**
     * @covers Core_Xhprof_Profile::__construct
     */
    public function testCanSetDataViaConstructor()
    {
        $data   = array('bla' => 123);
        $object = new Core_Xhprof_Profile($data);
        $this->assertEquals($data, $object->getData());
    }

    /**
     * @covers Core_Xhprof_Profile::getCallCount
     */
    public function testCanGetCallCount()
    {
        $data  = array('main()' => array(
            // complete wall time = 100msec, threshold = 50msec
            'ct' => 1234,
        ));
        $this->_object->setData($data);

        $this->assertEquals(1234, $this->_object->getCallCount());
    }

    /**
     * @covers Core_Xhprof_Profile::getWallTime
     */
    public function testCanGetWallTime()
    {
        $data  = array('main()' => array(
            // complete wall time = 100msec, threshold = 50msec
            'wt' => 100000,
        ));
        $this->_object->setData($data);

        $this->assertEquals(100000, $this->_object->getWallTime());
    }

    /**
     * @covers Core_Xhprof_Profile::getCpuTime
     */
    public function testCanGetCpuTime()
    {
        $data  = array('main()' => array(
            'cpu' => 90000,
        ));
        $this->_object->setData($data);

        $this->assertEquals(90000, $this->_object->getCpuTime());
    }

    /**
     * @covers Core_Xhprof_Profile::getMemoryUsage
     */
    public function testCanGetMemoryUsage()
    {
        $data  = array('main()' => array(
            'mu' => 123456,
        ));
        $this->_object->setData($data);

        $this->assertEquals(123456, $this->_object->getMemoryUsage());
    }

    /**
     * @covers Core_Xhprof_Profile::getPeakMemoryUsage
     */
    public function testCanGetPeakMemoryUsage()
    {
        $data  = array('main()' => array(
            'pmu' => 123456,
        ));
        $this->_object->setData($data);

        $this->assertEquals(123456, $this->_object->getPeakMemoryUsage());
    }
}