<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Validate
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Validate
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Validate
 */
abstract class Core_Validate_TestAbstract extends PHPUnit_Framework_TestCase
{
    /**
     * @var array Items considered valid
     */
    protected $_valid   = array();

    /**
     * @var array Items considered invalid
     */
    protected $_invalid = array();

    /**
     * @var Core_Validate_Abstract
     */
    protected $_object;

    /**
     * @param mixed $value
     *
     * @dataProvider getValid
     * @covers Core_Validate_Abstract::isValid
     */
    public function testIsValid($value)
    {
        $this->assertTrue($this->_object->isValid($value));
    }

    /**
     * @param mixed $value
     *
     * @dataProvider getInvalid
     * @covers Core_Validate_Abstract::isValid
     */
    public function testIsNotValid($value)
    {
        $this->assertFalse($this->_object->isValid($value));
    }

    /**
     * @return array
     */
    public function getValid()
    {
        return $this->_valid;
    }

    /**
     * @return array
     */
    public function getInvalid()
    {
        return $this->_invalid;
    }
}