<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Validate
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Validate
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Validate
 */
class Core_Validate_PhoneTest extends Core_Validate_TestAbstract
{
    /**
     * @var array Items considered valid
     */
    protected $_valid   = array(
        // No city prefix
        '123456'                    => array('123456'),
        '123-456'                   => array('123-456'),
        '123 - 456'                 => array('123 - 456'),

        // City prefix
        '035123456'                 => array('035123456'),
        '0354564985'                => array('0354564985'),
        '035 - 123 - 456'           => array('035 - 123 - 456'),
        '035/123-4567'              => array('035/123-4567'),
        '035 / 123 - 4567'          => array('035 / 123 - 4567'),

        // Area and city prefix
        '00385035123456'            => array('00385035123456'),
        '+385035123456'             => array('+385035123456'),
        '00385 35 / 123 - 456'      => array('00385 35 / 123 - 456'),
        '003850354564985'           => array('003850354564985'),
        '+3850354564985'            => array('+3850354564985'),
    );

    /**
     * @var array Items considered invalid
     */
    protected $_invalid = array(
        '12323'                     => array('12323'),
        '00385035123456355'         => array('00385035123456355'),
        '01a 1234 567'              => array('01a 1234 567'),
        '01 / 1234 / 567'           => array('01 / 1234 / 567'),
    );

    /**
     * @var Core_Validate_Phone
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Validate_Phone('phone');
    }

    /**
     * @param string $phone
     *
     * @covers Core_Validate_Phone::isValid
     * @dataProvider getValid
     */
    public function testIsValid($phone)
    {
        parent::testIsValid($phone);
    }

    /**
     * @param string $phone
     *
     * @covers Core_Validate_Phone::isValid
     * @dataProvider getInvalid
     */
    public function testIsNotValid($phone)
    {
        parent::testIsNotValid($phone);
    }
}