<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Validate
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Validate
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Validate
 */
class Core_Validate_OibTest extends Core_Validate_TestAbstract
{
    /**
     * @var array Items considered valid
     */
    protected $_valid   = array(
        'pho'   => array('07146487052'),
        'ivana' => array('07404061307'),
        'dado'  => array('41337289522'),
        'bujas' => array('57329564182'),
    );

    /**
     * @var array Items considered invalid
     */
    protected $_invalid = array(
        'too-short'        => array(1234567890),
        'non-numeric'      => array('non-numeric'),
        'invalid-checksum' => array(41337289523),
    );

    /**
     * @var Core_Validate_Oib
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Validate_Oib;
    }

    /**
     * @param int $oib
     *
     * @covers Core_Validate_Oib::isValid
     * @dataProvider getValid
     */
    public function testIsValid($oib)
    {
        parent::testIsValid($oib);
    }

    /**
     * @param int $oib
     *
     * @covers Core_Validate_Oib::isValid
     * @dataProvider getInvalid
     */
    public function testIsNotValid($oib)
    {
        parent::testIsNotValid($oib);
    }
}