<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Validate
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Validate
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Validate
 */
class Core_Validate_NotemptyTest extends  Core_Validate_TestAbstract
{
    /**
     * @var array Items considered valid
     */
    protected $_valid   = array(
        array(true),

        array( 0),
        array( 1),
        array(-1),

        array( 0.0),
        array( 1.0),
        array(-1.0),

        array('0'),
        array('0.0'),
        array('null'),
        array('true'),
        array('false'),

        array(array(0)),
        array(array(0.0)),

        array(array('')),
        array(array('0')),
        array(array('0.0')),
        array(array('null')),
        array(array('true')),
        array(array('false')),

        array(STDERR),
    );

    /**
     * @var array Items considered invalid
     */
    protected $_invalid = array(
        array(null),

        array(false),

        array(''),
        array('   '),
        array("\t\t"),
        array("\n\n"),
        array("\r\n"),
        array("\r"),
        array("\n\r\n\r\t\n  \n"),

        array(array()),
    );


    /**
     * @var Core_Validate_NotEmpty
     */
    protected $_object;

    public function __construct($name = null, array $data = array(), $dataName = '')
    {
        // additional valid types
        $this->_valid[] = array(new StdClass);
        $this->_valid[] = array($this);

        parent::__construct($name, $data, $dataName);
    }

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->_object = new Core_Validate_Notempty;
    }

    /**
     * @param string $value
     *
     * @covers Core_Validate_NotEmpty::isValid
     * @covers Core_Validate_NotEmpty::<protected>
     * @dataProvider getValid
     */
    public function testIsValid($value)
    {
        parent::testIsValid($value);
    }

    /**
     * @param string $value
     *
     * @covers Core_Validate_NotEmpty::isValid
     * @covers Core_Validate_NotEmpty::<protected>
     * @dataProvider getInvalid
     */
    public function testIsNotValid($value)
    {
        parent::testIsNotValid($value);
    }

    /**
     * @covers Core_Validate_NotEmpty::getAngularRepresentation
     */
    public function testCanGetAngularRepresentation()
    {
        $this->assertEquals(
            array(
                'required' => array(
                    'errorMessage' => 'Oh noez!',
                    'config'       => 'required',
                    'attribName'   => 'required',
                )
            ),
            $this->_object->getAngularRepresentation('Oh noez!')
        );
    }
}