<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Validate
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Validate
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Validate
 */
class Core_Validate_EmailTest extends Core_Validate_TestAbstract
{
    /**
     * @var array Items considered valid
     */
    protected $_valid   = array(
        'dado@burza.hr'          => array('dado@burza.hr'),
        'gagana_76_@hotmail.com' => array('gagana_76_@hotmail.com'),
        'neki-mail.sa+plusom_i-svime@hotmail-bla.com' => array('neki-mail.sa+plusom_i-svime@hotmail-bla.com'),
    );

    /**
     * @var array Items considered invalid
     */
    protected $_invalid = array(
        'dado' => array('dado'),
        'dado' => array('dado@burza')
    );

    /**
     * @var Core_Validate_Email
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Validate_Email;
    }

    /**
     * @param string $email
     *
     * @covers Core_Validate_Email::isValid
     * @dataProvider getValid
     */
    public function testIsValid($email)
    {
        parent::testIsValid($email);
    }

    /**
     * @param string $email
     *
     * @covers Core_Validate_Email::isValid
     * @dataProvider getInvalid
     */
    public function testIsNotValid($email)
    {
        parent::testIsNotValid($email);
    }
}