<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Util
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Util
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Util
 */
class Core_UtilTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Util
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Util;
    }

    /**
     * @covers Core_Util::stringToBytes
     */
    public function testStringToBytes()
    {
        // Remove the following lines when you implement this test.
        $this->assertEquals(1,    $this->_object->stringToBytes('1'));
        $this->assertEquals(25,    $this->_object->stringToBytes('25'));

        $this->assertEquals(pow(2, 10), $this->_object->stringToBytes('1k'));
        $this->assertEquals(pow(2, 10), $this->_object->stringToBytes('1k'));
        $this->assertEquals(3 * pow(2, 10), $this->_object->stringToBytes('3k'));

        $this->assertEquals(pow(2, 20), $this->_object->stringToBytes('1m'));
        $this->assertEquals(pow(2, 20), $this->_object->stringToBytes('1M'));
        $this->assertEquals(3.7 * pow(2, 20), $this->_object->stringToBytes('3.7M'));

        $this->assertEquals(pow(2, 30), $this->_object->stringToBytes('1g'));
        $this->assertEquals(pow(2, 30), $this->_object->stringToBytes('1G'));

        $this->assertEquals(pow(2, 40), $this->_object->stringToBytes('1t'));
        $this->assertEquals(pow(2, 40), $this->_object->stringToBytes('1T'));
    }
}
