<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Session
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Session
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Session
 */
class Core_SessionTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Session
     */
    protected $_object;

    protected function setUp()
    {
        // unit test enabled: true = does not in fact start session
        Zend_Session::$_unitTestEnabled = true;
        $this->_object = new Core_Session;
        $_SESSION = array();
        global $_SESSION;
    }

    protected function tearDown()
    {
        Zend_Session_Namespace::unlockAll();

        // unset all namespaces
        foreach (Zend_Session::getIterator() as $space) {
            try {
                Zend_Session::namespaceUnset($space);
            } catch (Zend_Session_Exception $e) {
                $this->assertRegexp('/read.only/i', $e->getMessage());
                return;
            }
        }
    }

    /**
     * @covers Core_Session::get
     */
    public function testGettingUnsetVariableReturnsNull()
    {
        $this->assertNull($this->_object->get('var'));
    }

    /**
     * @covers Core_Session::set
     * @covers Core_Session::get
     * @depends testGettingUnsetVariableReturnsNull
     */
    public function testCanSetAndGetVariable()
    {

        $this->_object->set('var', 'alpha');
        $this->assertEquals('alpha', $this->_object->get('var'));
    }

    /**
     * @covers Core_Session::del
     * @depends testCanSetAndGetVariable
     */
    public function testCanUnsetVariable()
    {
        $this->_object->set('var', 'alpha');
        $this->_object->del('var');
        $this->assertNull($this->_object->get('var'));
    }

    /**
     * @covers Core_Session::del
     * @depends testCanUnsetVariable
     */
    public function testDelReturnsVariable()
    {
        $this->_object->set('var', 'alpha');
        $value = $this->_object->del('var');
        $this->assertEquals('alpha', $value);
    }

}
