<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Router
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Router
 * @group      Core_Router_Route
 */
class Core_Router_Route_StaticTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Router_Route_Static
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Router_Route_Static;
    }

    /**
     * @covers Core_Router_Route_Static::match
     * @covers Core_Router_Route_Static::<protected>
     */
    public function testCanMatchPathWithExactMatch()
    {
        $this->_object->setPattern('/info/impressum/');
        $this->assertTrue($this->_object->match('/info/impressum/', '/'));
    }

    /**
     * @covers Core_Router_Route_Static::match
     * @covers Core_Router_Route_Static::<protected>
     */
    public function testCanMatchPathWithoutTrailingSeparator()
    {
        $this->_object->setPattern('/info/impressum');
        $this->assertTrue($this->_object->match('/info/impressum/', '/'));
    }

    /**
     * @covers Core_Router_Route_Static::match
     * @covers Core_Router_Route_Static::<protected>
     */
    public function testWillNotMatchRouteIfMismatchIsNotOnlyInTrailingSeparator()
    {
        $this->_object->setPattern('/info/impressum');
        $this->assertFalse($this->_object->match('/info/impressum/people', '/'));
    }

    /**
     * @covers Core_Router_Route_Static::match
     * @covers Core_Router_Route_Static::<protected>
     * @depends testCanMatchPathWithExactMatch
     */
    public function testWillDisregardCaseWhenMatchingRoute()
    {
        $this->_object->setPattern('/info/impressum/');
        $this->assertTrue($this->_object->match('/info/IMPRESSUM/', '/'));
    }

    /**
     * @covers Core_Router_Route_Static::path
     */
    public function testCanAssemblePath()
    {
        $this->_object->setPattern('/info/impressum');
        $this->assertEquals('/info/impressum', $this->_object->path('/'));
    }


    /**
     * @covers Core_Router_Route_Static::path
     */
    public function testCanAssemblePathWithBase()
    {
        $this->_object->setPattern('/info/impressum')->setBase('/some/base');
        $this->assertEquals('/some/base/info/impressum', $this->_object->path('/'));
    }

    /**
     * @covers Core_Router_Route_Static::path
     */
    public function testParamsAndResetFlagWillBeIgnoredWhenAssemblingPathIfUseQueryIsDisabled()
    {
        $this->_object->setPattern('/info/impressum');
        $this->assertEquals('/info/impressum', $this->_object->path('/', array('one' => 2), true));
    }

    /**
     * @covers Core_Router_Route_Static::path
     */
    public function testWillAppendParamsAsQueryStringIfUseQueryStringIsEnabled()
    {
        $this->_object
            ->setPattern('/info/impressum')
            ->setUseQuery(true);

        $this->assertEquals('/info/impressum?abc=2', $this->_object->path('/', array('abc' => 2), true));
    }
    
    /**
     * @covers Core_Router_Route_Static::path
     */
    public function testWillNotAppendQueryStringSeparatorIfNoQueryStringIsGiven()
    {
        $this->_object
            ->setPattern('/info/impressum')
            ->setUseQuery(true);

        $this->assertEquals('/info/impressum', $this->_object->path('/', array('abc' => null), true));
    }
}