<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Router
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Router
 * @group      Core_Router_Route
 */
class Core_Router_Route_Plugin_RestTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Router_Route_Plugin_Rest
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Router_Route_Plugin_Rest;
    }

    /**
     * @covers Core_Router_Route_Plugin_Rest::match
     * @covers Core_Router_Route_Plugin_Rest::<protected>
     */
    public function testWillUseLowercasedMethodForAction()
    {
        $route  = $this->getMock('Core_Router_Route_Interface');
        $route
            ->expects($this->once())
            ->method('addValues')
            ->with($this->equalTo(array('action' => 'get')));
        $this->_object->setRoute($route);

        $values = $this->_object->match(
            array(),
            array('Accept' => '*/*', 'Method' => 'GET', 'Origin' => 'example.com')
        );
    }

    /**
     * @covers Core_Router_Route_Plugin_Rest::match
     * @covers Core_Router_Route_Plugin_Rest::<protected>
     */
    public function testWillProxyEntityIfSet()
    {
        $route  = $this->getMock('Core_Router_Route_Interface');
        $route
            ->expects($this->once())
            ->method('addValues')
            ->with($this->equalTo(array('action' => 'get', 'entity' => 'articles')));
        $this->_object->setRoute($route);

        $values = $this->_object->match(
            array('entity' => 'articles'),
            array('Accept' => '*/*', 'Method' => 'GET', 'Origin' => 'example.com')
        );
    }

    /**
     * @covers Core_Router_Route_Plugin_Rest::match
     * @covers Core_Router_Route_Plugin_Rest::<protected>
     */
    public function testWillChangeActionToOneIfIdIsSet()
    {
        $route  = $this->getMock('Core_Router_Route_Interface');
        $route
            ->expects($this->once())
            ->method('addValues')
            ->with($this->equalTo(array('action' => 'getOne', 'entity' => 'articles')));
        $this->_object->setRoute($route);

        $values = $this->_object->match(
            array('entity' => 'articles', 'id' => 23),
            array('Accept' => '*/*', 'Method' => 'GET', 'Origin' => 'example.com')
        );
    }

    /**
     * @covers Core_Router_Route_Plugin_Rest::match
     * @covers Core_Router_Route_Plugin_Rest::<protected>
     */
    public function testWillChangeActionToOneRelationIfIdAndRelationIsSet()
    {
        $route  = $this->getMock('Core_Router_Route_Interface');
        $route
            ->expects($this->once())
            ->method('addValues')
            ->with($this->equalTo(array('action' => 'getOneimages', 'entity' => 'articles')));
        $this->_object->setRoute($route);

        $values = $this->_object->match(
            array('entity' => 'articles', 'id' => 23, 'relation' => 'images'),
            array('Accept' => '*/*', 'Method' => 'GET', 'Origin' => 'example.com')
        );
    }

    /**
     * @covers Core_Router_Route_Plugin_Rest::match
     * @covers Core_Router_Route_Plugin_Rest::<protected>
     */
    public function testWillNotChangeActionToRelationIfIdIsNotSetButRelationIsSet()
    {
        $route  = $this->getMock('Core_Router_Route_Interface');
        $route
            ->expects($this->once())
            ->method('addValues')
            ->with($this->equalTo(array('action' => 'getOneimages', 'entity' => 'articles')));
        $this->_object->setRoute($route);

        $values = $this->_object->match(
            array('entity' => 'articles', 'id' => 23, 'relation' => 'images'),
            array('Accept' => '*/*', 'Method' => 'GET', 'Origin' => 'example.com')
        );
    }
}
