<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_QueryLanguage
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_QueryLanguage
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_QueryLanguage
 */
class Core_QueryLanguageTest extends PHPUnit_Framework_TestCase
{
    protected $_object;

    protected function setup()
    {
        $query = $this->getMock('Core_QueryLanguage_Query');
        $this->_object = new Core_QueryLanguage($query);
    }

    /**
     * @covers Core_QueryLanguage::getAdapter
     * @expectedException RuntimeException
     */
    public function testGettingUnknownAdapterThrowsException()
    {
        $this->_object->getAdapter('some-unknown-adapter');
    }

    /**
     * @covers Core_QueryLanguage::__construct
     * @covers Core_QueryLanguage::getQuery
     */
    public function testConstructorCanSetQueryWhenPassingDslString()
    {
        $this->markTestIncomplete('Parser needed to complete this test');
        
        $queryLanguage = new Core_QueryLanguage('DSL');
        $this->assertInstanceOf('Core_QueryLanguage_Query', $queryLanguage->getQuery());
    }

    /**
     * @covers Core_QueryLanguage::__construct
     * @covers Core_QueryLanguage::getQuery
     */
    public function testConstructorCanSetQueryWhenPassingArray()
    {
        $queryLanguage = new Core_QueryLanguage(array('select' => 'field', 'limit' => 10));
        $this->assertInstanceOf('Core_QueryLanguage_Query', $queryLanguage->getQuery());
    }

    /**
     * @covers Core_QueryLanguage::__construct
     * @covers Core_QueryLanguage::getQuery
     */
    public function testConstructorCanSetQueryWhenPassingQuery()
    {
        $queryLanguage = new Core_QueryLanguage(new Core_QueryLanguage_Query);
        $this->assertInstanceOf('Core_QueryLanguage_Query', $queryLanguage->getQuery());
    }

    /**
     * @covers Core_QueryLanguage::setQuery
     * @covers Core_QueryLanguage::getQuery
     */
    public function testSettingQueryAsDslStringCanSetQuery()
    {
        $this->markTestIncomplete('Parser needed to complete this test');
        $this->_object->setQuery('DSL');
        $this->assertInstanceOf('Core_QueryLanguage_Query', $this->_object->getQuery());
    }

    /**
     * @covers Core_QueryLanguage::setQuery
     * @covers Core_QueryLanguage::getQuery
     */
    public function testSettingQueryAsArrayCanSetQuery()
    {
        $this->_object->setQuery(array('select' => 'field', 'limit' => 10));
        $this->assertInstanceOf('Core_QueryLanguage_Query', $this->_object->getQuery());
    }

    /**
     * @covers Core_QueryLanguage::setAdapter
     * @covers Core_QueryLanguage::getAdapter
     */
    public function testSettingAndGettingTheAdapter()
    {
        $adapter = $this->getMock('Core_QueryLanguage_Adapter_Interface', array('getQuery', 'setQuery'));

        $adapter
            ->expects($this->once())
            ->method('setQuery')
            ->with($this->_object->getQuery())
            ->will($this->returnSelf());

        $this->_object->setAdapter('someAdapter', $adapter);
        $this->assertSame($adapter, $this->_object->getAdapter('someAdapter'));
    }

    /**
     * @covers Core_QueryLanguage::setAdapter
     * @covers Core_QueryLanguage::getAdapter
     */
    public function testGettingTheAdapterSetsAdapterQuery()
    {
        $adapter = $this->getMock('Core_QueryLanguage_Adapter_Interface', array('getQuery', 'setQuery'));

        $adapter
            ->expects($this->once())
            ->method('setQuery')
            ->with($this->_object->getQuery())
            ->will($this->returnSelf());

        $this->_object->setAdapter('someAdapter', $adapter);
        $this->assertSame($adapter, $this->_object->getAdapter('someAdapter'));
    }
}