<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_HTMLPurifier
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_HTMLPurifier
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_HTMLPurifier
 */
class Core_HTMLPurifierTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_HTMLPurifier
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_HTMLPurifier;
    }

    /**
     * @covers Core_HTMLPurifier::__construct
     */
    public function testCanCreateAnInstanceOfHTMLPurifier()
    {
        $this->assertInstanceOf('HTMLPurifier', $this->_object);
    }

    /**
     * @covers Core_HTMLPurifier::__construct
     */
    public function testPassingAZendConfigInstanceWillConvertToAnArrayAndPassToParent()
    {
        $options = array('separator' => '@');
        $config  = $this->getMock('Zend_Config', null, array($options));

        $object  = new Core_HTMLPurifier($config);
        $this->assertEquals($options, $object->config);
    }
}

// Fake HTMLPurifier
class HTMLPurifier
{
    public $config;

    public function __construct($config)
    {
        $this->config = $config;
    }
}