<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Group_CollectionTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Form_Group_Collection
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Form_Group_Collection;
    }

    /**
     * @covers Core_Form_Group_Collection::getMacro
     */
    public function testDefaultMacroIsSet()
    {
        $this->assertEquals('collection', $this->_object->getMacro());
    }

    /**
     * @covers Core_Form_Group_Collection::getAttribs
     */
    public function testDefaultMandatoryAttribsForDefaultContextAreSet()
    {
        $this->_object->setName('form');
        $attribs = $this->_object->getAttribs(Core_Form::CONTEXT_DEFAULT);

        $this->assertArrayHasKey('data-next-index', $attribs);
        $this->assertArrayHasKey('data-marker',     $attribs);
        $this->assertArrayHasKey('id',              $attribs);
    }

    /**
     * @covers Core_Form_Group_Collection::getAttribs
     */
    public function testDefaultMandatoryAttribsForAngularContextAreSet()
    {
        $this->_object
            ->setId('foo')
            ->setName('form');
        $attribs = $this->_object->getAttribs(Core_Form::CONTEXT_ANGULAR);

        $this->assertArrayHasKey('name',     $attribs);
        $this->assertArrayHasKey('ng-model', $attribs);
        $this->assertArrayHasKey('id',       $attribs);
    }

    /**
     * @covers Core_Form_Group_Collection::getGroups
     */
    public function testCanFetchElements()
    {
        $object = $this->getMock('Core_Form_Group_Collection', array('_getItems'));
        $object
            ->expects($this->once())
            ->method('_getItems');
        $object->getGroups();
    }

    /**
     * @covers Core_Form_Group_Collection::getGroup
     */
    public function testCanFetchElement()
    {
        $object = $this->getMock('Core_Form_Group_Collection', array('_getItem'));
        $object
            ->expects($this->once())
            ->method('_getItem')
            ->with($this->equalTo('foo'));

        $object->getGroup('foo');
    }

}