<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_WysiwygTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Form_Element_Wysiwyg
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = $this->getMockForAbstractClass('Core_Form_Element_Wysiwyg');
    }

    protected function tearDown()
    {
        Core_Application::resetInstance();
    }

    /**
     * @covers Core_Form_Element_Wysiwyg::setPreset
     * @covers Core_Form_Element_Wysiwyg::getPreset
     */
    public function testCanSetAndGetPreset()
    {
        $this->_object->setPreset('arr');

        $this->assertEquals('arr', $this->_object->getPreset());
    }

    /**
     * @covers Core_Form_Element_Wysiwyg::getPreset
     */
    public function testDefaultPresetIsDefault()
    {
        $this->assertEquals('default', $this->_object->getPreset());
    }

    /**
     * @covers Core_Form_Element_Wysiwyg::setWysiwygOptions
     * @covers Core_Form_Element_Wysiwyg::getWysiwygOptions
     */
    public function testCanSetAndGetWysiwygOptions()
    {
        $this->_object->setWysiwygOptions(array('abc' => 123));

        $this->assertEquals(array('abc' => 123), $this->_object->getWysiwygOptions());
    }

    /**
     * @covers Core_Form_Element_Wysiwyg::getWysiwygOptions
     */
    public function testIfNoWysiwygOptionsIsSetWillPullItFromApplicationInstanceAsDefinedConfigComponent()
    {
        $container = $this->_mockContainer('invalidConfigComponent', array('a' => 'b'), array('preset' => 'foo'));
        Core_Application::getInstance()->setContainer($container);

        $object    = new Invalid_Form_Element_Wysiwyg;
        $object->setPreset('foo');

        $this->assertSame(array('a' => 'b'), $object->getWysiwygOptions());
    }

    /**
     * @covers Core_Form_Element_Wysiwyg::getWysiwygOptions
     */
    public function testWillConvertInstanceOfZend_ConfigToArray()
    {
        $config    = $this->getMock('Zend_Config', array(), array(array()));
        $config
            ->expects($this->once())
            ->method('toArray')
            ->will($this->returnValue(array('a' => 'b')));

        $container = $this->_mockContainer('invalidConfigComponent', $config);
        Core_Application::getInstance()->setContainer($container);

        $object    = new Invalid_Form_Element_Wysiwyg;

        $this->assertSame(array('a' => 'b'), $object->getWysiwygOptions());
    }

    /**
     * @covers Core_Form_Element_Wysiwyg::getAttribs
     */
    public function testAttribsWillContainWysiwygOptionsInDefaultContext()
    {
        $object = new Invalid_Form_Element_Wysiwyg;
        $object
            ->setWysiwygOptions(array('abc'))
            ->setName('form');
        $attribs = $object->getAttribs(Core_Form::CONTEXT_DEFAULT);

        $this->assertArrayHasKey('data-invalid',    $attribs);
    }

    /**
     * @covers Core_Form_Element_Wysiwyg::getAttribs
     * @covers Core_Form_Element_Wysiwyg::<protected>
     */
    public function testAttribsWillContainWysiwygOptionsInAngularContext()
    {
        $object = new Invalid_Form_Element_Wysiwyg;
        $object
            ->setWysiwygOptions(array('abc'))
            ->setName('form');
        $attribs = $object->getAttribs(Core_Form::CONTEXT_ANGULAR);

        $this->assertArrayHasKey('data-invalid',    $attribs);
    }
}

class Invalid_Form_Element_Wysiwyg extends Core_Form_Element_Wysiwyg
{
    protected $_wysiwygType     = 'data-invalid';
    protected $_configComponent = 'invalidConfigComponent';
}
