<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_UrlTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Form_Element_Url
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Form_Element_Url;
    }

    /**
     * @covers Core_Form_Element_Url::getInputType
     */
    public function testInputTypeIsSet()
    {
        $this->assertEquals('url', $this->_object->getInputType());
    }

    /**
     * @covers Core_Form_Element_Url::init
     */
    public function testInitWillAutoAddUrlFilter()
    {
        $object = $this->getMock('Core_Form_Element_Url', array('createFilter', '_configureValidator'));
        $object
            ->expects($this->once())
            ->method('createFilter')
            ->with($this->equalTo('url'), $this->equalTo('url'));

        $object->init();
    }

    /**
     * @covers Core_Form_Element_Url::init
     */
    public function testInitWillAutoAddUrlValidator()
    {
        $object = $this->getMock('Core_Form_Element_Url', array('createFilter', '_configureValidator'));
        $object
            ->expects($this->once())
            ->method('_configureValidator')
            ->with($this->equalTo('url'));

        $object->init();
    }
}
