<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_TextareaTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Form_Element_Textarea
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Form_Element_Textarea;
    }

    /**
     * @covers Core_Form_Element_Textarea::getTemplate
     */
    public function testDefaultTemplateIsSet()
    {
        $template = $this->getMock('Twig_TemplateInterface');
        $view     = $this->getMock('Twig_Environment', array('loadTemplate'));
        $view
            ->expects($this->once())
            ->method('loadTemplate')
            ->with($this->equalTo('Core/Form/Element/Textarea.tpl'))
            ->will($this->returnValue($template));
        $this->_object->setView($view);

        $this->assertEquals($template, $this->_object->getTemplate());
    }

    /**
     * @covers Core_Form_Element_Textarea::getMacro
     */
    public function testDefaultMacroIsSet()
    {
        $this->assertEquals('element', $this->_object->getMacro());
    }

    /**
     * @covers Core_Form_Element_Textarea::setRows
     * @covers Core_Form_Element_Textarea::getRows
     */
    public function testCanSetAndGetRows()
    {
        $this->_object->setRows(22);

        $this->assertEquals(22, $this->_object->getRows());
    }

    /**
     * @covers Core_Form_Element_Textarea::getRows
     */
    public function testDefaultRowsCountIsSent()
    {
        $this->assertEquals(10, $this->_object->getRows());
    }

    /**
     * @covers Core_Form_Element_Textarea::setCols
     * @covers Core_Form_Element_Textarea::getCols
     */
    public function testCanSetAndGetCols()
    {
        $this->_object->setCols(33);

        $this->assertEquals(33, $this->_object->getCols());
    }

    /**
     * @covers Core_Form_Element_Textarea::setCols
     * @covers Core_Form_Element_Textarea::getCols
     */
    public function testDefaultColsCountIsSet()
    {
        $this->assertEquals(50, $this->_object->getCols());
    }

    /**
     * @covers Core_Form_Element_Textarea::getAttribs
     */
    public function testDefaultMandatoryAttribsForDefaultContextAreSet()
    {
        $this->_object
            ->setName('form');
        $attribs = $this->_object->getAttribs(Core_Form::CONTEXT_DEFAULT);

        $this->assertArrayHasKey('id',   $attribs);
        $this->assertArrayHasKey('name', $attribs);
        $this->assertArrayHasKey('cols', $attribs);
        $this->assertArrayHasKey('rows', $attribs);
    }

    /**
     * @covers Core_Form_Element_Textarea::getAttribs
     */
    public function testDefaultMandatoryAttribsForAngularContextAreSet()
    {
        $this->_object
            ->setName('form');
        $attribs = $this->_object->getAttribs(Core_Form::CONTEXT_ANGULAR);

        $this->assertArrayHasKey('id',              $attribs);
        $this->assertArrayHasKey('ng-model',        $attribs);
        $this->assertArrayHasKey('cf-form-element', $attribs);
        $this->assertArrayHasKey('name',            $attribs);
        $this->assertArrayHasKey('cols',            $attribs);
        $this->assertArrayHasKey('rows',            $attribs);
    }
}
