<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_SelectTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Form_Element_Select
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Form_Element_Select;
    }

    /**
     * @covers Core_Form_Element_Select::getMacro
     */
    public function testDefaultMacroIsSet()
    {
        $this->assertEquals('element', $this->_object->getMacro());
    }

    /**
     * @covers Core_Form_Element_Select::getTemplate
     */
    public function testDefaultTemplateIsSet()
    {
        $template = $this->getMock('Twig_TemplateInterface');
        $view     = $this->getMock('Twig_Environment', array('loadTemplate'));
        $view
            ->expects($this->once())
            ->method('loadTemplate')
            ->with($this->equalTo('Core/Form/Element/Select.tpl'))
            ->will($this->returnValue($template));
        $this->_object->setView($view);

        $this->assertEquals($template, $this->_object->getTemplate());
    }

    /**
     * @covers Core_Form_Element_Select::getAttribs
     */
    public function testDefaultMandatoryAttribsForDefaultContextAreSet()
    {
        $this->_object->setName('el')->setValue(23);
        $attribs = $this->_object->getAttribs(Core_Form::CONTEXT_DEFAULT);

        $this->assertArrayHasKey('id',    $attribs);
        $this->assertArrayHasKey('name',  $attribs);
    }

    /**
     * @covers Core_Form_Element_Select::getAttribs
     */
    public function testDefaultMandatoryAttribsForAngularContextAreSet()
    {
        $this->_object->setName('el');
        $attribs = $this->_object->getAttribs(Core_Form::CONTEXT_ANGULAR);

        $this->assertArrayHasKey('id',              $attribs);
        $this->assertArrayHasKey('ng-model',        $attribs);
        $this->assertArrayHasKey('cf-form-element', $attribs);
        $this->assertArrayHasKey('name',            $attribs);
    }

    /**
     * @covers Core_Form_Element_Select::getRawValue
     */
    public function testIfNoRawValueAndNoPlaceholderSetRawValueEqualsFirstPossibleValue()
    {
        $object       = new Invalid_Form_Element_Select;
        $object->test = $this;
        $object->setPossibleValues(array('a' => 1, 'b' => 2));

        $this->assertEquals('a', $object->getRawValue());
    }
}

class Invalid_Form_Element_Select extends Core_Form_Element_Select
{
    public $test;

    public function hasValidator($name)
    {
        return true;
    }

    public function getValidator($name)
    {
        $validator = $this->test->getMockForAbstractClass('Core_Validate_Abstract', array(), '', true, true, true, array('setOptions'));
        return $validator;
    }
}
