<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_RangeTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Form_Element_Range
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Form_Element_Range;
    }

    /**
     * @covers Core_Form_Element_Range::getInputType
     */
    public function testInputTypeIsSet()
    {
        $this->assertEquals('range', $this->_object->getInputType());
    }

    /**
     * @covers Core_Form_Element_Range::init
     */
    public function testInitWillAutoAddFloatFilter()
    {
        $object = $this->getMock('Core_Form_Element_Range', array('createFilter'));
        $object
            ->expects($this->once())
            ->method('createFilter')
            ->with($this->equalTo('float'), $this->equalTo('float'));

        $object->init();
    }
}
