<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_RadioTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Form_Element_Radio
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Form_Element_Radio;
    }

    /**
     * @covers Core_Form_Element_Radio::getMacro
     */
    public function testDefaultMacroIsSet()
    {
        $this->assertEquals('element', $this->_object->getMacro());
    }

    /**
     * @covers Core_Form_Element_Radio::getTemplate
     */
    public function testDefaultTemplateIsSet()
    {
        $template = $this->getMock('Twig_TemplateInterface');
        $view     = $this->getMock('Twig_Environment', array('loadTemplate'));
        $view
            ->expects($this->once())
            ->method('loadTemplate')
            ->with($this->equalTo('Core/Form/Element/Input/Radio.tpl'))
            ->will($this->returnValue($template));
        $this->_object->setView($view);

        $this->assertEquals($template, $this->_object->getTemplate());
    }
}