<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_ObjectTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Form_Element_Object
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Form_Element_Object;
    }

    /**
     * @covers Core_Form_Element_Object::getTemplate
     */
    public function testDefaultTemplateIsSet()
    {
        $template = $this->getMock('Twig_TemplateInterface');
        $view     = $this->getMock('Twig_Environment', array('loadTemplate'));
        $view
            ->expects($this->once())
            ->method('loadTemplate')
            ->with($this->equalTo('Core/Form/Element/Object.tpl'))
            ->will($this->returnValue($template));
        $this->_object->setView($view);

        $this->assertEquals($template, $this->_object->getTemplate());
    }

    /**
     * @covers Core_Form_Element_Object::getMacro
     */
    public function testDefaultMacroIsSet()
    {
        $this->assertEquals('element', $this->_object->getMacro());
    }
    
    /**
     * @covers Core_Form_Element_Object::getAttribs
     */
    public function testDefaultMandatoryAttribsForDefaultContextAreSet()
    {
        $this->_object
            ->setName('form');
        $attribs = $this->_object->getAttribs(Core_Form::CONTEXT_DEFAULT);

        $this->assertArrayHasKey('id',   $attribs);
        $this->assertArrayHasKey('name', $attribs);
    }

    /**
     * @covers Core_Form_Element_Object::getAttribs
     */
    public function testDefaultMandatoryAttribsForAngularContextAreSet()
    {
        $this->_object
            ->setName('form');
        $attribs = $this->_object->getAttribs(Core_Form::CONTEXT_ANGULAR);

        $this->assertArrayHasKey('id',              $attribs);
        $this->assertArrayHasKey('ng-model',        $attribs);
        $this->assertArrayHasKey('cf-form-element', $attribs);
        $this->assertArrayHasKey('name',            $attribs);
    }
    
    /**
     * @covers Core_Form_Element_Object::setValue
     */
    public function testCanSetObjectAsValue()
    {
        $obj      = new StdClass;
        $obj->foo = 23;
        $this->_object->setValue($obj);
        
        $this->assertEquals('{"foo":23}', $this->_object->getRawValue());
    }
    
    /**
     * @covers Core_Form_Element_Object::setValue
     */
    public function testCanSetArrayAsValue()
    {
        $arr = array('bla' => 99);
        $this->_object->setValue($arr);
        
        $this->assertEquals('{"bla":99}', $this->_object->getRawValue());
    }

    /**
     * @covers Core_Form_Element_Object::getValue
     */
    public function testCanGetValueAsArray()
    {
        $obj      = new StdClass;
        $obj->foo = 23;
        $this->_object->setValue($obj);
        
        $this->assertEquals(array('foo' => 23), $this->_object->getValue());
    }
}
