<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_MultiValue_AbstractTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Form_Element_MultiValue_Abstract
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = $this->getMockForAbstractClass('Core_Form_Element_MultiValue_Abstract');
    }

    /**
     * @covers Core_Form_Element_MultiValue_Abstract::setRawValue
     */
    public function testSettingEmptyRawValueWillSetNull()
    {
        $this->_object->setRawValue('');

        $this->assertNull($this->_object->getRawValue());
    }

    /**
     * @covers Core_Form_Element_MultiValue_Abstract::setPossibleValues
     * @covers Core_Form_Element_MultiValue_Abstract::getPossibleValues
     */
    public function testCanSetAndGetPossibleValues()
    {
        $possibleValues = array('a' => 'Label for a', 'b' => 'Label for b');

        $object          = new Invalid_Form_Element_MultiValueInvalid;
        $object->test    = $this;
        $object->options = array('array' => array('a', 'b', null));
        $object->setPossibleValues($possibleValues);

        $this->assertEquals($possibleValues, $object->getPossibleValues());
    }

    /**
     * @covers Core_Form_Element_MultiValue_Abstract::setPossibleValues
     * @covers Core_Form_Element_MultiValue_Abstract::getPossibleValues
     */
    public function testWillAutoAddInArrayValidatorWhenSettingPossibleValues()
    {
        $possibleValues = array('a' => 'Label for a', 'b' => 'Label for b');

        $object          = new Invalid_Form_Element_MultiValueInvalid;
        $object->test    = $this;
        $object->options = array('array' => array('a', 'b', null));

        $object->setPossibleValues($possibleValues);
    }
    

    /**
     * @covers Core_Form_Element_MultiValue_Abstract::setPossibleValues
     * @covers Core_Form_Element_MultiValue_Abstract::getPossibleValues
     */
    public function testWillTranslatePossibleValuesIfTranslatorAvaliable()
    {        
        $translator = $this->getMock('Zend_Translate', array('translate'), array(), '', false);
        $translator
            ->expects($this->at(0))
            ->method('translate')
            ->with($this->equalTo('Label for a'))
            ->will($this->returnValue('Labela za a'));
        $translator
            ->expects($this->at(1))
            ->method('translate')
            ->with($this->equalTo('Label for b'))
            ->will($this->returnValue('Labela za b'));
        
        $object       = new Invalid_Form_Element_MultiValueInvalid;
        $object->test = false;
        $object
            ->setTranslator($translator)
            ->setPossibleValues(array('a' => 'Label for a', 'b' => 'Label for b'));

        $this->assertEquals(array('a' => 'Labela za a', 'b' => 'Labela za b'), $object->getPossibleValues());
    }
}

class Invalid_Form_Element_MultiValueInvalid extends Core_Form_Element_MultiValue_Abstract
{
    public $test;
    public $options = array();

    public function hasValidator($name)
    {
        return true;
    }

    public function getValidator($name)
    {
        $validator = $this->test->getMockForAbstractClass('Core_Validate_Abstract', array(), '', true, true, true, array('setOptions'));
        $validator
            ->expects($this->test->once())
            ->method('setOptions')
            ->with($this->test->equalTo($this->options));
        return $validator;
    }
    
    protected function _configureValidator($name, array $options = null)
    {
        if ($this->test) {
            parent::_configureValidator($name, $options);
        }
    }
}