<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_InputTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Form_Element_Input
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = $this->getMockForAbstractClass('Core_Form_Element_Input');
    }

    /**
     * @covers Core_Form_Element_Input::getInputType
     */
    public function testCanGetInputType()
    {
        $object = new Invalid_Form_Element_Input_Whatever;

        $this->assertEquals('whatever', $object->getInputType());
    }

    /**
     * @covers Core_Form_Element_Input::getTemplate
     */
    public function testDefaultTemplateIsSet()
    {
        $template = $this->getMock('Twig_TemplateInterface');
        $view     = $this->getMock('Twig_Environment', array('loadTemplate'));
        $view
            ->expects($this->once())
            ->method('loadTemplate')
            ->with($this->equalTo('Core/Form/Element/Input.tpl'))
            ->will($this->returnValue($template));
        $this->_object->setView($view);

        $this->assertEquals($template, $this->_object->getTemplate());
    }

    /**
     * @covers Core_Form_Element_Input::getMacro
     */
    public function testDefaultMacroIsSet()
    {
        $this->assertEquals('element', $this->_object->getMacro());
    }

    /**
     * @covers Core_Form_Element_Input::getAttribs
     */
    public function testDefaultMandatoryAttribsForDefaultContextAreSet()
    {
        $object = new Invalid_Form_Element_Input_Whatever;
        $object->setName('el')->setValue(23);
        $attribs = $object->getAttribs(Core_Form::CONTEXT_DEFAULT);

        $this->assertArrayHasKey('id',    $attribs);
        $this->assertArrayHasKey('name',  $attribs);
        $this->assertArrayHasKey('value', $attribs);
        $this->assertArrayHasKey('type',  $attribs);
    }

    /**
     * @covers Core_Form_Element_Input::getAttribs
     */
    public function testDefaultMandatoryAttribsForAngularContextAreSet()
    {
        $object = new Invalid_Form_Element_Input_Whatever;
        $object->setName('el');
        $attribs = $object->getAttribs(Core_Form::CONTEXT_ANGULAR);

        $this->assertArrayHasKey('id',              $attribs);
        $this->assertArrayHasKey('ng-model',        $attribs);
        $this->assertArrayHasKey('cf-form-element', $attribs);
        $this->assertArrayHasKey('name',            $attribs);
        $this->assertArrayHasKey('type',            $attribs);
    }
}

class Invalid_Form_Element_Input_Whatever extends Core_Form_Element_Input
{
    protected $_inputType = 'whatever';
}
