<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_EmailTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Form_Element_Email
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Form_Element_Email;
    }

    /**
     * @covers Core_Form_Element_Email::getInputType
     */
    public function testInputTypeIsSet()
    {
        $this->assertEquals('email', $this->_object->getInputType());
    }

    /**
     * @covers Core_Form_Element_Email::init
     */
    public function testInitWillAutoAddEmailValidator()
    {
        $object = $this->getMock('Core_Form_Element_Email', array('_configureValidator'));
        $object
            ->expects($this->once())
            ->method('_configureValidator')
            ->with($this->equalTo('email'));

        $object->init();
    }
}
