<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_CkeditorTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Form_Element_Ckeditor
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Form_Element_Ckeditor;
    }

    /**
     * @covers Core_Form_Element_Ckeditor::getWysiwygOptions
     */
    public function testIfNoWysiwygOptionsIsSetWillPullItFromApplicationInstanceAsDefinedConfigComponent()
    {
        $container = $this->_mockContainer('ckeditorConfig', array('a' => 'b'), array('preset' => 'foo'));
        Core_Application::getInstance()->setContainer($container);
        $this->_object->setPreset('foo');

        $this->assertSame(array('a' => 'b'), $this->_object->getWysiwygOptions());
    }
}
