<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_CheckboxTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Form_Element_Checkbox
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Form_Element_Checkbox;
    }

    /**
     * @covers Core_Form_Element_Checkbox::getInputType
     */
    public function testInputTypeIsSet()
    {
        $this->assertEquals('checkbox', $this->_object->getInputType());
    }

    /**
     * @covers Core_Form_Element_Checkbox::setChecked
     * @covers Core_Form_Element_Checkbox::isChecked
     */
    public function testCanSetAndGetChecked()
    {
        $this->_object->setChecked(true);

        $this->assertTrue($this->_object->isChecked());
    }

    /**
     * @covers Core_Form_Element_Checkbox::isChecked
     */
    public function testIsNotCheckedByDefault()
    {
        $this->assertFalse($this->_object->isChecked());
    }

    /**
     * @covers Core_Form_Element_Checkbox::setCheckedValue
     * @covers Core_Form_Element_Checkbox::getCheckedValue
     */
    public function testCanSetAndGetCheckedValue()
    {
        $this->_object->setCheckedValue(23);

        $this->assertEquals(23, $this->_object->getCheckedValue());
    }

    /**
     * @covers Core_Form_Element_Checkbox::getCheckedValue
     */
    public function testDefaultCheckedValueIsTrue()
    {
        $this->assertTrue($this->_object->getCheckedValue());
    }

    /**
     * @covers Core_Form_Element_Checkbox::setUncheckedValue
     * @covers Core_Form_Element_Checkbox::getUncheckedValue
     */
    public function testCanSetAndGetUncheckedValue()
    {
        $this->_object->setUncheckedValue(33);

        $this->assertEquals(33, $this->_object->getUncheckedValue());
    }

    /**
     * @covers Core_Form_Element_Checkbox::getUncheckedValue
     */
    public function testDefaultUncheckedValueIsFalse()
    {
        $this->assertFalse($this->_object->getUncheckedValue());
    }

    /**
     * @covers Core_Form_Element_Checkbox::setRawValue
     */
    public function testSettingRawValueToCheckedValueWillSetCheckedToTrue()
    {
        $this->_object
            ->setCheckedValue('grr')
            ->setRawValue('grr');

        $this->assertEquals('grr', $this->_object->getRawValue());
        $this->assertTrue($this->_object->isChecked());
    }

    /**
     * @covers Core_Form_Element_Checkbox::setRawValue
     */
    public function testSettingRawValueTo1WillSetCheckedValueToTrue()
    {
        $this->_object
            ->setCheckedValue(true)
            ->setRawValue('1');

        $this->assertTrue($this->_object->getRawValue());
    }

    /**
     * @covers Core_Form_Element_Checkbox::setRawValue
     */
    public function testSettingRawValueToAnythingExceptCheckedValueWillSetCheckedToFalseAndRawValueToUncheckedValue()
    {
        $this->_object
            ->setCheckedValue('grr')
            ->setUncheckedValue('aaa')
            ->setRawValue('foo');

        $this->assertEquals('aaa', $this->_object->getRawValue());
        $this->assertFalse($this->_object->isChecked());
    }

    /**
     * @covers Core_Form_Element_Checkbox::getCheckedAttrib
     */
    public function testCheckedAttribWillBeSetIfChecked()
    {
        $this->_object->setChecked(true);

        $this->assertEquals('checked', $this->_object->getCheckedAttrib());
    }

    /**
     * @covers Core_Form_Element_Checkbox::getCheckedAttrib
     */
    public function testCheckedAttribWillNotBeSetIfNotChecked()
    {
        $this->_object->setChecked(false);

        $this->assertNull($this->_object->getCheckedAttrib());
    }

    /**
     * @covers Core_Form_Element_Checkbox::getMacro
     */
    public function testDefaultMacroIsSet()
    {
        $this->assertEquals('element_label_behind', $this->_object->getMacro());
    }

    /**
     * @covers Core_Form_Element_Checkbox::getTemplate
     */
    public function testDefaultTemplateIsSet()
    {
        $template = $this->getMock('Twig_TemplateInterface');
        $view     = $this->getMock('Twig_Environment', array('loadTemplate'));
        $view
            ->expects($this->once())
            ->method('loadTemplate')
            ->with($this->equalTo('Core/Form/Element/Input/Checkbox.tpl'))
            ->will($this->returnValue($template));
        $this->_object->setView($view);

        $this->assertEquals($template, $this->_object->getTemplate());
    }

    /**
     * @covers Core_Form_Element_Checkbox::getAttribs
     */
    public function testDefaultMandatoryAttribsForDefaultContextAreSet()
    {
        $this->_object
            ->setName('el')
            ->setChecked(true);
        $attribs = $this->_object->getAttribs(Core_Form::CONTEXT_DEFAULT);

        $this->assertArrayHasKey('id',      $attribs);
        $this->assertArrayHasKey('name',    $attribs);
        $this->assertArrayHasKey('value',   $attribs);
        $this->assertArrayHasKey('type',    $attribs);
        $this->assertArrayHasKey('checked', $attribs);
    }

    /**
     * @covers Core_Form_Element_Checkbox::getAttribs
     */
    public function testDefaultMandatoryAttribsForAngularContextAreSet()
    {
        $this->_object->setName('el');
        $attribs = $this->_object->getAttribs(Core_Form::CONTEXT_ANGULAR);

        $this->assertArrayHasKey('id',              $attribs);
        $this->assertArrayHasKey('ng-model',        $attribs);
        $this->assertArrayHasKey('cf-form-element', $attribs);
        $this->assertArrayHasKey('name',            $attribs);
        $this->assertArrayHasKey('type',            $attribs);
    }
}
