<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_ButtonTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Form_Element_Button
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Form_Element_Button;
    }

    /**
     * @covers Core_Form_Element_Button::getTemplate
     */
    public function testDefaultTemplateIsSet()
    {
        $template = $this->getMock('Twig_TemplateInterface');
        $view     = $this->getMock('Twig_Environment', array('loadTemplate'));
        $view
            ->expects($this->once())
            ->method('loadTemplate')
            ->with($this->equalTo('Core/Form/Element/Button.tpl'))
            ->will($this->returnValue($template));
        $this->_object->setView($view);

        $this->assertEquals($template, $this->_object->getTemplate());
    }

    /**
     * @covers Core_Form_Element_Button::getMacro
     */
    public function testDefaultMacroIsSet()
    {
        $this->assertEquals('element_basic', $this->_object->getMacro());
    }

    /**
     * @covers Core_Form_Element_Button::getAttribs
     * @covers Core_Form_Element_Button::<protected>
     */
    public function testWillAddNgClickAttribIfTypeIsSubmitForAngularContext()
    {
        $this->_object->setAttrib('type', 'submit');
        $attribs = $this->_object->getAttribs(Core_Form::CONTEXT_ANGULAR);

        $this->assertArrayHasKey('ng-click', $attribs);
    }

    /**
     * @covers Core_Form_Element_Button::isIgnored
     */
    public function testIsIgnoredByDefault()
    {
        $this->assertTrue($this->_object->isIgnored());
    }
}
