<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Event
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Event
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Event
 */
class Core_EventTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Event
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Event('not', 'there');
    }

    /**
     * @covers Core_Event_Interface
     */
    public function testCoversInterface()
    {
        $this->assertTrue(true);
    }

    /**
     * @covers Core_Event::setName
     * @covers Core_Event::getName
     */
    public function testCanSetAndGetName()
    {
        $this->_object->setName('SomeEventName');
        $this->assertEquals('SomeEventName', $this->_object->getName());
    }

    /**
     * @covers Core_Event::setSubject
     * @covers Core_Event::getSubject
     */
    public function testCanSetAndGetSubject()
    {
        $this->_object->setSubject('Subject is this');
        $this->assertEquals('Subject is this', $this->_object->getSubject());
    }

    /**
     * @covers Core_Event::isProcessed
     */
    public function testEventIsNotProcessedByDefault()
    {
        $this->assertFalse($this->_object->isProcessed());
    }

    /**
     * @covers Core_Event::setIsProcessed
     * @covers Core_Event::isProcessed
     */
    public function testCanSetAndGetIsProcessed()
    {
        $this->_object->setIsProcessed(true);
        $this->assertTrue($this->_object->isProcessed());
    }

    /**
     * @covers Core_Event::isPropagated
     */
    public function testEventIsPropagatedByDefault()
    {
        $this->assertTrue($this->_object->isPropagated());
    }

    /**
     * @covers Core_Event::setIsPropagated
     * @covers Core_Event::isPropagated
     */
    public function testCanSetAndGetPropagatedFlag()
    {
        $this->_object->setIsPropagated(false);
        $this->assertFalse($this->_object->isPropagated());
    }

    /**
     * @covers Core_Event::setParams
     * @covers Core_Event::getParams
     */
    public function testCanSetAndGetParams()
    {
        $this->_object->setParams(array(1, 2, 3));
        $this->assertEquals(array(1, 2, 3), $this->_object->getParams());
    }

    /**
     * @covers Core_Event::setParam
     * @covers Core_Event::getParam
     */
    public function testCanSetSingleParamByName()
    {
        $this->_object->setParam('parName', 'parVal');
        $this->assertEquals('parVal', $this->_object->getParam('parName'));
    }

    /**
     * @covers Core_Event::hasParam
     */
    public function testCanTestIfParamExists()
    {
        $this->_object->setParam('parName', 'parVal');
        $this->assertTrue($this->_object->hasParam('parName'));
    }

    /**
     * @covers Core_Event::getParam
     */
    public function testFetchingValuesOfNonExistantParamsReturnsNull()
    {
        $this->assertNull($this->_object->getParam('parName'));
    }

    /**
     * @covers Core_Event::__construct
     */
    public function testCanSetNameSubjectAndParamsViaConstructor()
    {
        $object = new Core_Event('subject', 'name', array('of', 'params'));
        $this->assertEquals('name', $object->getName());
        $this->assertEquals('subject', $object->getSubject());
        $this->assertEquals(array('of', 'params'), $object->getParams());
    }
}
