<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Embed
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Embed
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Embed
 */
class Core_Embed_Parser_ImageTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Embed_Parser_Image
     */
    protected $_object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->_object = new Core_Embed_Parser_Image;
    }

    /**
     * @covers Core_Embed_Parser_Image::get
     */
    public function testWillReturnImageType()
    {
        $response = $this->_object->get('http://example.invalid/image.jpeg');
        $this->assertEquals('image', $response->type);
    }
    
    /**
     * @covers Core_Embed_Parser_Image::get
     */
    public function testWillReturnUrl()
    {
        $url      = 'http://example.invalid/image.jpeg';
        $response = $this->_object->get($url);
        $this->assertEquals($url, $response->url);
    }
    
    /**
     * @covers Core_Embed_Parser_Image::get
     */
    public function testWillReturnUrlAsTitle()
    {
        $url      = 'http://example.invalid/image.jpeg';
        $response = $this->_object->get($url);
        $this->assertEquals($url, $response->title);
    }
}
