<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Embed
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Embed
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Embed
 */
class Core_Embed_Parser_FallbackTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Embed_Parser_Fallback
     */
    protected $_object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->_object = new Core_Embed_Parser_Fallback;
    }

    /**
     * @covers Core_Embed_Parser_Fallback::get
     */
    public function testWillReturnPhotoType()
    {
        $response = $this->_object->get('http://example.invalid/foo');
        $this->assertEquals('link', $response->type);
    }
    
    /**
     * @covers Core_Embed_Parser_Fallback::get
     */
    public function testWillReturnUrl()
    {
        $url      = 'http://example.invalid/foo';
        $response = $this->_object->get($url);
        $this->assertEquals($url, $response->url);
    }
    
    /**
     * @covers Core_Embed_Parser_Fallback::get
     */
    public function testWillReturnUrlAsTitle()
    {
        $url      = 'http://example.invalid/foo';
        $response = $this->_object->get($url);
        $this->assertEquals($url, $response->title);
    }
}
