<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Embed
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Embed
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Embed
 */
class Core_Embed_Parser_AbstractTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Embed_Parser_Abstract
     */
    protected $_object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->_object = $this->getMock('Core_Embed_Parser_Abstract', array('_parse'));
    }

    /**
     * @covers Core_Embed_Parser_Abstract::setHttpClient
     * @covers Core_Embed_Parser_Abstract::getHttpClient
     */
    public function testCanSetAndGetHttpClient()
    {
        $httpClient = $this->getMock('Zend_Http_Client');
        $this->_object->setHttpClient($httpClient);
        $this->assertEquals($httpClient, $this->_object->getHttpClient());
    }

    /**
     * @covers Core_Embed_Parser_Abstract::getHttpClient
     */
    public function testIfNoHttpClientInstanceGivenCreateANewZendHttpClient()
    {
        $this->assertInstanceOf('Zend_Http_Client', $this->_object->getHttpClient());
    }
    
    /**
     * @covers Core_Embed_Parser_Abstract::get
     * /
    public function testWillFetchURLOnGet()
    {
        // setup the HTTP client mock which will be invoked
        $httpClient = $this->getMock('Zend_Http_Client', array('setUri', 'request'));
        $httpClient
            ->expects($this->once())
            ->method('setUri')
            ->with($this->equalTo('http://www.example.invalid'))
            ->will($this->returnValue($httpClient));
        $response = $this->getMock('Zend_Http_Response', array(), array(null, array()));
        $httpClient
            ->expects($this->once())
            ->method('request')
            ->will($this->returnValue($response));
        $this->_object->setHttpClient($httpClient);
        
        $this->_object->get('http://www.example.invalid');
    }
     * 
     */
    
    /**
     * @covers Core_Embed_Parser_Abstract::get
     * @covers Core_Embed_Parser_Abstract::<protected>
     */
    public function testWillParseURLResponse()
    {                
        // we're mocking the SUT because we wish to verify that we're calling the  _parse() method
        $response = $this->getMock('Core_Embed_Response', array('get'), array(array()));
        $response
            ->expects($this->once())
            ->method('get')
            ->with($this->equalTo('foo'))
            ->will($this->returnValue('bla'));
        $object   = $this->getMock('Core_Embed_Parser_Abstract', array('_parse'));
        $object
            ->expects($this->once())
            ->method('_parse')
            ->with($this->equalTo('http://www.example.invalid'))
            ->will($this->returnValue($response));
        
        $response = $object->get('http://www.example.invalid');
        $this->assertEquals('bla', $response->get('foo'));
    }
}
