<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Dispatcher_Location
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Dispatcher_Location
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Dispatcher_Location
 */
class Core_Dispatcher_LocationTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Dispatcher_Location
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Dispatcher_Location;
    }

    protected function tearDown()
    {
        Core_Application::resetInstance();
    }

    /**
     * @covers Core_Dispatcher_Location::setRequest
     * @covers Core_Dispatcher_Location::getRequest
     */
    public function testCanSetAndGetRequest()
    {
        $request = $this->getMock('Core_Request');
        $this->_object->setRequest($request);
        $this->assertSame($request, $this->_object->getRequest());
    }

    /**
     * @covers Core_Dispatcher_Location::getRequest
     */
    public function testIfNoRequestIsSetGetRequestWillPullItFromApplicationInstanceAsRequest()
    {
        $request   = $this->_mockRequest();
        $container = $this->_mockContainer('Request', $request);
        Core_Application::getInstance()->setContainer($container);

        $this->assertSame($request, $this->_object->getRequest());
    }

    /**
     * @covers Core_Dispatcher_Location::setOptions
     */
    public function testCanSetOptions()
    {
        $options = array('module' => 'fooModule');
        $this->_object->setOptions($options);
        $this->assertEquals('fooModule', $this->_object->getModule());
    }


    /**
     * @covers Core_Dispatcher_Location::setOptions
     */
    public function testWillSkipForbiddenOptions()
    {
        $this->_object->setModule('fooModule1');
        $options = array('options' => array('module' => 'fooModule2'));
        $this->_object->setOptions($options);

        $this->assertEquals('fooModule1', $this->_object->getModule());
    }

    /**
     * @covers Core_Dispatcher_Location::__construct
     */
    public function testCanSetOptionsViaConstructor()
    {
        $options = array('module' => 'fooModule');
        $object  = new Core_Dispatcher_Location($options);

        $this->assertEquals('fooModule', $object->getModule());
    }

    /**
     * @covers Core_Dispatcher_Location::setModule
     * @covers Core_Dispatcher_Location::getModule
     */
    public function testCanSetAndGetModule()
    {
        $this->_object->setModule('fooModule');
        $this->assertEquals('fooModule', $this->_object->getModule());
    }

    /**
     * @covers Core_Dispatcher_Location::getModule
     */
    public function testIfModuleIsEmptyWillTryToPullFromRequestParams()
    {
        $container = $this->_mockContainer('Request', $this->_mockRequest('module', 'fooModuleFromRequest'));
        Core_Application::getInstance()->setContainer($container);

        $this->assertEquals('fooModuleFromRequest', $this->_object->getModule());
    }

    /**
     * @covers Core_Dispatcher_Location::setController
     * @covers Core_Dispatcher_Location::getController
     */
    public function testCanSetAndGetController()
    {
        $this->_object->setController('fooController');
        $this->assertEquals('fooController', $this->_object->getController());
    }

    /**
     * @covers Core_Dispatcher_Location::getController
     */
    public function testIfControllerIsEmptyWillTryToPullFromRequestParams()
    {
        $container = $this->_mockContainer('Request', $this->_mockRequest('controller', 'fooControllerFromRequest'));
        Core_Application::getInstance()->setContainer($container);

        $this->assertEquals('fooControllerFromRequest', $this->_object->getController());
    }

    /**
     * @covers Core_Dispatcher_Location::setAction
     * @covers Core_Dispatcher_Location::getAction
     */
    public function testCanSetAndGetAction()
    {
        $this->_object->setAction('fooAction');
        $this->assertEquals('fooAction', $this->_object->getAction());
    }

    /**
     * @covers Core_Dispatcher_Location::getAction
     */
    public function testIfActionIsEmptyWillTryToPullFromRequestParams()
    {
        $container = $this->_mockContainer('Request', $this->_mockRequest('action', 'fooActionFromRequest'));
        Core_Application::getInstance()->setContainer($container);

        $this->assertEquals('fooActionFromRequest', $this->_object->getAction());
    }

    protected function _mockRequest($paramName = null, $paramValue = null)
    {
        $request   = $this->getMock('Core_Request');
        if ($paramName) {
            $request
                ->expects($this->once())
                ->method('getParam')
                ->with($this->equalTo($paramName))
                ->will($this->returnValue($paramValue));
        }
        return $request;
    }
}
