<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Detector
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Detector
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Detector
 */
class Core_Detector_ResponseTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Detector_Client
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Detector_Response;
    }

    /**
     * @covers Core_Detector_Response::setData
     * @covers Core_Detector_Response::getData
     */
    public function testCanSetAndGetData()
    {
        $data = array('some' => 'data');
        $this->_object->setData($data);
        $this->assertEquals($data, $this->_object->getData());
    }

    /**
     * @covers Core_Detector_Response::reduceTo
     *
     * @depends testCanSetAndGetData
     */
    public function testCanReduceResponseToRequestedProperties()
    {
        $this->_object->setData(
            array(
                'screen' => array(
                    'color'  => array(
                        'depth' => 24,
                    ),
                    'width'  => 42,
                    'height' => 55,
                ),
                'dado' => 'zakon',
            )
        );

        $this->_object->reduceTo(
            array(
                'screen.color.depth',
                'screen.width',
                'dado',
            )
        );
        $this->assertEquals(
            array(
                'screen' => array(
                    'color'  => array(
                        'depth' => 24,
                    ),
                    'width' => 42,
                ),
                'dado' => 'zakon'
            ),
            $this->_object->getData()
        );
    }
}