<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Config
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Config
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Config
 */
class Core_ConfigTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var string
     */
    protected $_files;
    
    /**
     * @var Core_Config
     */
    protected $_object;
    
    protected function setUp()
    {
        // where are the file fixtures?
        $this->_files  = TESTS_ROOT .'/resources/fixtures/Core/Config';
    }

    /**
     * @covers Core_Config::__construct
     */
    public function testCanLoadConfig()
    {
        $object = new Core_Config($this->_files .'/array.php');
        
        $this->assertEquals('aaa', $object->normal);
    }
    
    /**
     * @covers Core_Config::__construct
     */
    public function testWillStripTranslationMarker()
    {
        $object = new Core_Config($this->_files .'/array.php');
        
        $this->assertEquals('translated string', $object->translated);
    }
}
