<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Config
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Config
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Config
 */
class Core_Config_IniTest extends PHPUnit_Framework_TestCase
{
    protected $_files;

    protected function setUp()
    {
        // where are the file fixtures?
        $this->_files  = TESTS_ROOT .'/resources/fixtures/Core/Config/Ini';
    }

    /**
     * @param string $key      Key of a value
     * @param string $expected Exact expected value (type and all)
     *
     * @covers Core_Config_Ini::__construct
     * @covers Core_Config_Ini::<protected>
     * @dataProvider keyToType
     */
    public function testWillRetainValueType($key, $expected)
    {
        $config   = new Core_Config_Ini($this->_files .'/types.ini');
        $this->_verifyType($config->{$key}, $expected);
    }

    /**
     * @param string $key      Key of a value
     * @param string $expected Exact expected value (type and all)
     *
     * @covers Core_Config_Ini::__construct
     * @covers Core_Config_Ini::<protected>
     * @dataProvider keyToType
     */
    public function testWillRetainValueTypeWithSections($key, $expected)
    {
        $config   = new Core_Config_Ini($this->_files .'/sections.ini', 'section');
        $this->_verifyType($config->{$key}, $expected);
    }

    /**
     * @covers Core_Config_Ini::__construct
     * @covers Core_Config_Ini::<protected>
     */
    public function testWillLoadClassConstants()
    {
        $config = new Core_Config_Ini($this->_files .'/constants.ini');
        $this->assertSame($config->one, 1);
    }

    /**
     * @covers Core_Config_Ini::__construct
     * @covers Core_Config_Ini::<protected>
     */
    public function testReferencingAnUndefinedClassConstantThrowsAZendConfigException()
    {
        $this->setExpectedException('Zend_Config_Exception');
        new Core_Config_Ini($this->_files .'/no-constants.ini');
    }

    /**
     * @covers Core_Config_Ini::__construct
     * @covers Core_Config_Ini::<protected>
     */
    public function testCanParseConfigWithSectionSeparatorInNameOrValue()
    {
        $config = new Core_Config_Ini($this->_files .'/separators.ini');
        $this->assertEquals('aaa', $config->param->get(':aaa'));
    }

    public function keyToType()
    {
        // see tests/fixtures/Core/Config/Ini/types.ini
        return array(
            array('ione',     1),
            array('ssone',    1),
            array('sdone',    1),

            array('foneone',  1.1),
            array('ssoneone', 1.1),
            array('sdoneone', 1.1),

            array('strue',   true),
            array('sfalse',  false),

            array('aonetwo', array('one', 'two')),

            // weird ones, prior to PHP 5.3 and INI_SCANNER_RAW
            // Values null, no and false results in "", yes and true results in 1
            array('syes',     1),
            array('btrue',    1),
            array('bfalse',   ''),
            array('snull',    ''),
            array('sno',      ''),

            array('qnull',    null),
        );
    }

    protected function _verifyType($value, $expected)
    {
        if ($value instanceof Zend_Config) {
            $value = $value->toArray();
        }
        $this->assertSame($expected, $value);
    }
}

class Invalid_Core_Config_Ini
{
    const ONE = 1;
}