<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Calendar
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Calendar
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Calendar
 * @group      Core_Calendar_Interval
 */
class Core_Calendar_Interval_MonthTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Calendar_Interval_Month
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Calendar_Interval_Month;
    }

    /**
     * @covers Core_Calendar_Interval_Month::setYear
     * @covers Core_Calendar_Interval_Month::getYear
     */
    public function testCanSpecifyYear()
    {
        $this->_object->setYear(2000);
        $this->assertEquals(2000, $this->_object->getYear());
    }

    /**
     * @covers Core_Calendar_Interval_Month::getYear
     */
    public function testIfNoYearSpecifiedWillDefaultToCurrent()
    {
        $this->assertEquals(date('Y'), $this->_object->getYear());
    }

    /**
     * @covers Core_Calendar_Interval_Month::setMonth
     * @covers Core_Calendar_Interval_Month::getMonth
     */
    public function testCanSpecifyMonth()
    {
        $this->_object->setMonth(12);
        $this->assertEquals(12, $this->_object->getMonth());
    }

    /**
     * @covers Core_Calendar_Interval_Month::getMonth
     */
    public function testIfNoMonthSpecifiedWillDefaultToCurrent()
    {
        $this->assertEquals(date('m'), $this->_object->getMonth());
    }

    /**
     * @covers Core_Calendar_Interval_Month::setDay
     * @covers Core_Calendar_Interval_Month::getDay
     */
    public function testCanSpecifyDay()
    {
        $this->_object->setDay(31);
        $this->assertEquals(31, $this->_object->getDay());
    }

    /**
     * @covers Core_Calendar_Interval_Month::setDate
     */
    public function testCanSpecifyDate()
    {
        $this->_object->setDate(
            array(
                'year'  => 2000,
                'month' => 12,
                'day'   => 31,
            )
        );
        $this->assertEquals(2000, $this->_object->getYear());
        $this->assertEquals(12, $this->_object->getMonth());
        $this->assertEquals(31, $this->_object->getDay());
    }
}
