<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Application
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Application
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Application
 * @group      Core_Application_Plugin
 */
class Core_Application_Plugin_EventHandler_TemplateFinderTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Application_Plugin_EventHandler_TemplateFinder
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Application_Plugin_EventHandler_TemplateFinder('templateFinder');
    }

    protected function tearDown()
    {
        Core_Application::resetInstance();
    }

    /**
     * @covers Core_Application_Plugin_EventHandler_TemplateFinder::setViewLoader
     * @covers Core_Application_Plugin_EventHandler_TemplateFinder::getViewLoader
     */
    public function testCanSetAndGetViewLoader()
    {
        $viewLoader = $this->getMock('Twig_LoaderInterface');
        $this->_object->setViewLoader($viewLoader);
        $this->assertEquals($viewLoader, $this->_object->getViewLoader());
    }

    /**
     * @covers Core_Application_Plugin_EventHandler_TemplateFinder::getViewLoader
     */
    public function testIfViewLoaderNotSetItWillFetchItFromApplicationAsViewLoader()
    {
        $viewLoader = $this->getMock('Twig_LoaderInterface');
        $container  = $this->_mockContainer('ViewLoader', $viewLoader);
        Core_Application::getInstance()->setContainer($container);

        $this->assertEquals($viewLoader, $this->_object->getViewLoader());
    }


    /**
     * @covers Core_Application_Plugin_EventHandler_TemplateFinder::eventHandler
     * @depends testCanSetAndGetViewLoader
     */
    public function testWillPrependModuleTemplatePathToViewLoaderStack()
    {
        // the location
        $viewLoader = $this->getMock('Twig_Loader_Filesystem', array(), array('foo'));
        $viewLoader
            ->expects($this->once())
            ->method('getPaths')
            ->will($this->returnValue(array('/path/1', '/path/2')));
        $viewLoader
            ->expects($this->once())
            ->method('setPaths')
            ->with($this->equalTo(array('/path/someModule', '/path/1', '/path/2')));
        $location = $this->getMock('Core_Dispatcher_Location');
        $finder   = $this->getMock('Core_Module_ResourceFinder', array('findTemplatesPath'));
        $finder
            ->expects($this->once())
            ->method('findTemplatesPath')
            ->with($this->equalTo($location))
            ->will($this->returnValue('/path/someModule'));
        $this->_object
            ->setResourceFinder($finder)
            ->setViewLoader($viewLoader);

        $event      = $this->getMock('Core_Event_Interface');
        $event
            ->expects($this->once())
            ->method('getParam')
            ->with($this->equalTo('location'))
            ->will($this->returnValue($location));
        $this->_object->eventHandler($event);
    }
}
