<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Application
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Application
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Application
 * @group      Core_Application_Plugin
 */
class Core_Application_Plugin_EventHandler_AutoResponseTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Application_Plugin_EventHandler_AutoResponse
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Application_Plugin_EventHandler_AutoResponse('autoResponse');
    }

    protected function tearDown()
    {
        Core_Application::resetInstance();
    }

    /**
     * @covers Core_Application_Plugin_EventHandler_AutoResponse::setResponse
     * @covers Core_Application_Plugin_EventHandler_AutoResponse::getResponse
     */
    public function testCanSetAndGetResponse()
    {
        $response = $this->getMock('Core_Response');
        $this->_object->setResponse($response);
        $this->assertEquals($response, $this->_object->getResponse());
    }

    /**
     * @covers Core_Application_Plugin_EventHandler_AutoResponse::getResponse
     */
    public function testIfViewNotSetItWillFetchItFromApplicationAsView()
    {
        $response   = $this->getMock('Core_Response');
        $container  = $this->_mockContainer('Response', $response);
        Core_Application::getInstance()->setContainer($container);

        $this->assertEquals($response, $this->_object->getResponse());
    }

    /**
     * @covers Core_Application_Plugin_EventHandler_AutoResponse::eventHandler
     * @depends testCanSetAndGetResponse
     */
    public function testWillWrapPassedDataToResponse()
    {
        $response = $this->getMock('Core_Response');
        $response
            ->expects($this->once())
            ->method('setBody')
            ->with($this->equalTo('foo'));
        $this->_object->setResponse($response);
        $event    = $this->getMock('Core_Event_Interface');

        $this->assertInstanceOf('Core_Response', $this->_object->eventHandler($event, 'foo'));
    }

    /**
     * @covers Core_Application_Plugin_EventHandler_AutoResponse::eventHandler
     * @depends testCanSetAndGetResponse
     */
    public function testWillNotWrapIfAlreadyResponse()
    {
        $response = $this->getMock('Core_Response');
        $event    = $this->getMock('Core_Event_Interface');

        $this->assertEquals($response, $this->_object->eventHandler($event, $response));
    }
}
