<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Application
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Application
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Application
 * @group      Core_Application_Plugin
 */
class Core_Application_Plugin_EventHandler_ArrayRenderTest extends CoreTest_Container_TestCase
{
    /**
     * @var Core_Application_Plugin_EventHandler_ArrayRender
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = new Core_Application_Plugin_EventHandler_ArrayRender('arrayRender');
    }

    protected function tearDown()
    {
        Core_Application::resetInstance();
    }

    /**
     * @covers Core_Application_Plugin_EventHandler_ArrayRender::setView
     * @covers Core_Application_Plugin_EventHandler_ArrayRender::getView
     */
    public function testCanSetAndGetView()
    {
        $view = $this->getMock('Twig_Environment');
        $this->_object->setView($view);
        $this->assertEquals($view, $this->_object->getView());
    }

    /**
     * @covers Core_Application_Plugin_EventHandler_ArrayRender::getView
     */
    public function testIfViewNotSetItWillFetchItFromApplicationAsView()
    {
        $view       = $this->getMock('Twig_Environment');
        $container  = $this->_mockContainer('View', $view);
        Core_Application::getInstance()->setContainer($container);

        $this->assertEquals($view, $this->_object->getView());
    }

    /**
     * @covers Core_Application_Plugin_EventHandler_ArrayRender::eventHandler
     * @depends testCanSetAndGetView
     */
    public function testWillRenderPassedArray()
    {
        $data     = array('a' => 1, 'b' => 2);
        $markup   = '<h1>markup from template</h1>';

        $location = $this->getMock('Core_Dispatcher_Location_Interface');
        $finder   = $this->getMock('Core_Module_ResourceFinder', array('findTemplate'));
        $finder
            ->expects($this->once())
            ->method('findTemplate')
            ->with($this->equalTo($location))
            ->will($this->returnValue('testrender.tmpl'));
        $template = $this->getMock('Twig_TemplateInterface');
        $template
            ->expects($this->once())
            ->method('render')
            ->with($this->equalTo($data))
            ->will($this->returnValue($markup));
        $view = $this->getMock('Twig_Environment');
        $view
            ->expects($this->once())
            ->method('loadTemplate')
            ->with($this->equalTo('testrender.tmpl'))
            ->will($this->returnValue($template));

        $this->_object
            ->setResourceFinder($finder)
            ->setView($view);

        $event    = $this->getMock('Core_Event_Interface');
        $event
            ->expects($this->once())
            ->method('getParam')
            ->with($this->equalTo('location'))
            ->will($this->returnValue($location));

        $this->assertEquals($markup, $this->_object->eventHandler($event, $data));
    }
}
