<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Application
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Application
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2013. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Application
 * @group      Core_Application_Plugin
 */
class Core_Application_Plugin_AbstractTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Application_Plugin_Abstract
     */
    protected $_object;

    protected function setUp()
    {
        $this->_object = $this->getMockForAbstractClass('Core_Application_Plugin_Abstract', array('name'));
    }

    /**
     * @covers Core_Application_Plugin_Abstract::setName
     * @covers Core_Application_Plugin_Abstract::getName
     */
    public function testCanSetAndGetName()
    {
        $this->_object->setName('bla');

        $this->assertEquals('bla', $this->_object->getName());
    }

    /**
     * @covers Core_Application_Plugin_Abstract::__construct
     * @covers Core_Application_Plugin_Abstract::getName
     */
    public function testCanSetNameViaConstructor()
    {
        $object = $this->getMockForAbstractClass('Core_Application_Plugin_Abstract', array('baz'));

        $this->assertEquals('baz', $object->getName());
    }

    /**
     * @covers Core_Application_Plugin_Abstract::setOptions
     * @depends testCanSetAndGetName
     */
    public function testSetOptions()
    {
        $this->_object->setOptions(array('name' => 'foo'));

        $this->assertEquals('foo', $this->_object->getName());
    }

    /**
     * @covers Core_Application_Plugin_Abstract::setOptions
     * @depends testSetOptions
     */
    public function testSettingUnknownOptionsThrowsAnInvalidArgumentException()
    {
        $this->setExpectedException('InvalidArgumentException');

        $this->_object->setOptions(array('no-such' => 'option'));
    }

    /**
     * @covers Core_Application_Plugin_Abstract::__construct
     * @depends testSetOptions
     */
    public function testSetOptionsViaConstructor()
    {
        $options = array('name' => 'some-name');
        $object  = $this->getMockForAbstractClass('Core_Application_Plugin_Abstract', array('overwritten', $options));

        $this->assertEquals('some-name', $object->getName());
    }
}