<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Router
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Router
 * @group      IntegrationTests
 */
class Core_Router_SubdirectoryRouteIntegrationTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Router
     */
    protected $_object;

    /**
     * @var Core_Config
     */
    protected $_config;

    /**
     * @var Core_Loader_PluginLoader
     */
    protected $_pluginLoader;

    /**
     * @var Core_Request
     */
    protected $_request;

    public function __construct()
    {
        // where is the file fixture?
        $path                = TESTS_ROOT .'/resources/fixtures/Core/Router/'. $this->_suiteName() .'.ini';
        $this->_config       = new Core_Config($path);
        $this->_pluginLoader = new Core_Loader_PluginLoader;
        $this->_request      = new Core_Request;
    }

    protected function setUp()
    {
        $this->_object = new Core_Router;
        $this->_object
            ->setPluginLoader($this->_pluginLoader)
            ->setRequest($this->_request)
            ->setConfig($this->_config);
    }

    /**
     * @covers Core_Router::route
     */
    public function testCanSetRouteBase()
    {
        $route = $this->_object->route('/some/directory/array/grr');
        $this->assertEquals(
            array(
                'module'     => 'form',
                'controller' => 'test',
                'action'     => 'array',
                'var'        => 'grr',
            ),
            $route->getValues()
        );
    }

    /**
     * @covers Core_Router::path
     */
    public function testCanGeneratePath()
    {
        $this->assertEquals(
            '/some/directory/string/23',
            $this->_object->path(array('action' => 'string', 'var' => 23), 'info')
        );
    }

    protected function _suiteName()
    {
        return strtolower(basename(__FILE__, 'IntegrationTest.php'));
    }
}
