<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Router
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Router
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Router
 * @group      IntegrationTests
 */
class Core_Router_RoutePluginHeadersInjectIntegrationTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Router
     */
    protected $_object;

    /**
     * @var Core_Request
     */
    protected $_request;

    public function __construct()
    {
        $this->_request = new Core_Request;
    }

    protected function setUp()
    {
        $this->_object = new Core_Router;
        $this->_object
            ->setRequest($this->_request);
    }

    /**
     * @covers Core_Router::route
     */
    public function testWillInjectHeadersToRoutePluginWhenMatching()
    {
        $_SERVER = array(
            'REQUEST_METHOD' => 'GET',
            'SERVER_NAME'    => 'example.com'
        );

        $route  = new Core_Router_Route_Static;
        $plugin = new Invalid_Router_Route_Plugin_Injected;
        $route
            ->setRequest($this->_request)
            ->setPattern('/match')
            ->addPlugin($plugin);
        $this->_object->addRoute($route);

        $this->_object->route('/match');

        $this->assertEquals(array('a' => null, 'hostname' => 'example.com', 'method' => 'GET'), $plugin->request);
    }
}

class Invalid_Router_Route_Plugin_Injected extends Core_Router_Route_Plugin_Abstract
{
    public $request;

    public function getHeadersRequest()
    {
        return array('a', 'hostname', 'method');
    }

    protected function _match(array $values, array $request = null)
    {
        $this->request = $request;
        return true;
    }
}
