<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 * @group      IntegrationTests
 */
class Core_Form_DynamicGroupsIntegrationTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Form
     */
    protected $_object;

    /**
     * @var Core_Config
     */
    protected $_config;

    /**
     * @var Core_Loader_PluginLoader
     */
    protected $_pluginLoader;

    public function __construct()
    {
        // where is the file fixture?
        $path                = TESTS_ROOT .'/resources/fixtures/Core/Form/'. $this->_suiteName() .'.ini';
        $this->_config       = new Core_Config($path);
    }

    protected function setUp()
    {
        // for Core_Plugin_Manager
        Core_Application::getInstance()->getContainer()
                ->PluginLoader = new Core_Loader_PluginLoader;

        $this->_object = new Core_Form;
        $this->_object->setConfig($this->_config);
    }

    /**
     * @covers Core_Form_Group_Collection::__construct
     * @covers Core_Form_Group_Collection::<protected>
     */
    public function testWillCreateCollectionOnPopulate()
    {
        $data = array(
            'group1' => array(
                13 => array('group2' => array('username' => 'dado1', 'password' => 'pwd1')),
            ),
        );
        $this->_object->populate($data);

        // auto-create and populate group 1
        $this->_object
            ->getGroup('group1')
                ->getGroup(1)
                    ->populate(array('group2' => array('username' => 'dado2', 'password' => 'pwd2')));

        $this->assertEquals(array(
            13 => array(
                'group2' => array('username' => 'dado1', 'password' => 'pwd1', 'foo' => null),
                'foo'    => null,
            ),
            1 => array(
                'group2' => array('username' => 'dado2', 'password' => 'pwd2', 'foo' => null),
                'foo'    => null,
            ),
        ), $this->_object->getGroup('group1')->getValues());
    }

    /**
     * @covers Core_Form_Group_Collection::__construct
     * @covers Core_Form_Group_Collection::<protected>
     */
    public function testWillCreateCollectionOnGetGroups()
    {
        $groups = $this->_object->getGroup('group1')->getGroups();

        $this->assertCount(2, $groups);
        $this->assertEquals(array(0, 1), array_keys($groups));
    }


    /**
     * @covers Core_Form_Group_Collection::__construct
     * @covers Core_Form_Group_Collection::<protected>
     */
    public function testCanHaveNestedCollections()
    {
        $data = array(
            array(
                'coll2' => array(
                    array('textarea' => 'idx 0.0 '),
                    array('textarea' => 'idx 0.1 '),
                ),
            ),
            array(
                'coll2' => array(
                    array('textarea' => 'idx 1.0 '),
                    array('textarea' => 'idx 1.1 '),
                ),
            )
        );

        $trimmed = array(
            array(
                'coll2' => array(
                    array('textarea' => 'idx 0.0'),
                    array('textarea' => 'idx 0.1'),
                ),
            ),
            array(
                'coll2' => array(
                    array('textarea' => 'idx 1.0'),
                    array('textarea' => 'idx 1.1'),
                ),
            )
        );
        $this->_object->populate(array('coll1' => $data));

        $this->assertEquals($trimmed, $this->_object->getGroup('coll1')->getValues());
    }

    protected function _suiteName()
    {
        return strtolower(basename(__FILE__, 'IntegrationTest.php'));
    }
}
