<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 * @group      IntegrationTests
 */
class Core_Form_DynamicElementsIntegrationTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Form
     */
    protected $_object;

    /**
     * @var Core_Config
     */
    protected $_config;

    /**
     * @var Core_Loader_PluginLoader
     */
    protected $_pluginLoader;

    public function __construct()
    {
        // where is the file fixture?
        $path                = TESTS_ROOT .'/resources/fixtures/Core/Form/'. $this->_suiteName() .'.ini';
        $this->_config       = new Core_Config($path);
    }

    protected function setUp()
    {
        // for Core_Plugin_Manager
        Core_Application::getInstance()->getContainer()
                ->PluginLoader = new Core_Loader_PluginLoader;

        $this->_object = new Core_Form;
        $this->_object->setConfig($this->_config);
    }

    /**
     * @covers Core_Form_Element_Collection::__construct
     * @covers Core_Form_Element_Collection::<protected>
     */
    public function testWillCreateCollectionOnPopulate()
    {
        $data = array(
            'images' => array(
                13 => 19,
            ),
        );
        $this->_object->populate($data);

        // auto-create and populate group 1
        $this->_object
            ->getElement('images')
                ->getElement(1)
                    ->setValue(33);

        $this->assertEquals(array(
            13 => 19,
            1 => 33,
        ), $this->_object->getElement('images')->getValue());
    }


    /**
     * @covers Core_Form_Group_Collection::__construct
     * @covers Core_Form_Group_Collection::<protected>
     */
    public function testWillCreateCollectionOnGetElements()
    {
        $elements = $this->_object->getElement('images')->getElements();

        $this->assertCount(2, $elements);
        $this->assertEquals(array(0, 1), array_keys($elements));
    }

    protected function _suiteName()
    {
        return strtolower(basename(__FILE__, 'IntegrationTest.php'));
    }
}
