<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 * @group      IntegrationTests
 */
class Core_Form_DisplayGroupIntegrationTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Form
     */
    protected $_object;

    /**
     * @var Core_Config
     */
    protected $_config;

    /**
     * @var Core_Loader_PluginLoader
     */
    protected $_pluginLoader;

    public function __construct()
    {
        // where is the file fixture?
        $path                = TESTS_ROOT .'/resources/fixtures/Core/Form/'. $this->_suiteName() .'.yml';
        $this->_config       = new Core_Config($path);
    }

    protected function setUp()
    {
        // for Core_Plugin_Manager
        Core_Application::getInstance()->getContainer()
                ->PluginLoader = new Core_Loader_PluginLoader;

        $this->_object = new Core_Form;
        $this->_object->setConfig($this->_config);
    }
    
    /**
     * @covers Core_Form_Group_Display::addGroup
     */
    public function testElementInDisplayGroupIsInParent()
    {
        $this->assertSame($this->_object->dgroup1->text1, $this->_object->text1);
    }
    
    /**
     * @covers Core_Form_Group_Display::populate
     */
    public function testCanPopulateElementViaParent()
    {
        $this->_object->populate(array('text1' => 'foo'));
        
        $this->assertEquals('foo', $this->_object->text1->value);
    }

    /**
     * @covers Core_Form_Group_Display::getValues
     */
    public function testValuesWillBeAvailableViaParent()
    {
        $this->_object->dgroup1->text1->value = 'bar';
        
        $this->assertEquals(array(
            'text1'    => 'bar',
            'text2'    => null,
            'group1'   => array('text3' => null),
            'group2'   => array('text4' => null),
            'collect1' => array(),
        ), $this->_object->getValues());
    }
    

    /**
     * @covers Core_Form_Group_Display::getValues
     */
    public function testCanHaveNestedDisplayGroups()
    {
        $this->_object->dgroup2->dgroup3->text2->value = 'bat';
        
        $this->assertEquals(array(
            'text1'    => null,
            'text2'    => 'bat',
            'group1'   => array('text3' => null),
            'group2'   => array('text4' => null),
            'collect1' => array(),
        ), $this->_object->getValues());
    }

    /**
     * @covers Core_Form_Group_Display::getElements
     */
    public function testElementWillBeAvailableViaGetElements()
    {
        $elements = $this->_object->dgroup1->getElements();
        
        $this->assertArrayHasKey('text1', $elements);
    }
    
    /**
     * @covers Core_Form_Group_Display::getElements
     */
    public function testElementWillNotBeAvailableViaParentsGetElements()
    {
        $elements = $this->_object->getElements();
        
        $this->assertArrayNotHasKey('text1', $elements);
    }

    /**
     * @covers Core_Form_Group_Display::getElements
     */
    public function testCanHaveDisplayGroupInCollection()
    {
        $group = $this->_object->collect1->getGroup(0);
        
        $this->assertInstanceOf('Core_Form_Group_Display', $group->dgroup6);
    }
    

    /**
     * @covers Core_Form_Group_Display::getElements
     */
    public function testErrorsAreNotWrappedInDisplayGroup()
    {
        $this->assertFalse($this->_object->isValid());
        
        $this->assertEquals(array('text1' => 'nope!'), $this->_object->getErrors());
    }

    protected function _suiteName()
    {
        return strtolower(basename(__FILE__, 'IntegrationTest.php'));
    }
}
