<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Embed
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Embed
 * @subpackage IntegrationTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Embed
 * @group      IntegrationTests
 * @group      pecl
 * @group      tidy
 */
class Core_Embed_FetchIntegrationTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var Core_Embed
     */
    protected $_object;

    /**
     * @var Core_Loader_PluginLoader
     */
    protected $_pluginLoader;

    public function __construct($name = null, array $data = array(), $dataName = '')
    {
        parent::__construct($name, $data, $dataName);
        $this->_pluginLoader = new Core_Loader_PluginLoader;
    }

    protected function setUp()
    {
        $this->_object = new Core_Embed;
        $this->_object
            ->setPluginLoader($this->_pluginLoader);
    }

    /**
     * @param string $url        URL to fetch
     * @param array  $properties Properties to check
     *
     * @covers Core_Embed::get
     * @dataProvider urls
     * @large
     */
    public function testCanFetchURL($url, $properties = array())
    {
        if (!function_exists('tidy_repair_string')) {
            $this->markTestSkipped('Core_Embed requires Tidy PECL, skipping');
        }

        $response = $this->_object->get($url);

        foreach ($properties as $name => $value) {
            $this->assertEquals($value, $response->get($name));
        }
    }

    /**
     * @return array
     */
    public function urls()
    {
        return array(
            // url, properties to verify
            array(
                'http://www.youtube.com/watch?v=lulkZSGgnrQ',
                array(
                    'type' => 'video',
                ),
            )
        );
    }
}
