<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage TemplateTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage TemplateTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
abstract class CoreTest_Template_TestCase extends PHPUnit_Framework_TestCase
{
    /**
     * @var string
     */
    protected $_template;

    /**
     * @var string
     */
    protected $_path;

    /**
     * @global Twig_Environment $twig
     *
     * @param type $name
     * @param array $data
     * @param type $dataName
     */
    public function __construct($name = NULL, array $data = array(), $dataName = '')
    {
        parent::__construct($name, $data, $dataName);

        global $twig;
        $this->_template = $twig->loadTemplate($this->_path);
    }

    /**
     * @return array
     */
    abstract public function getMatches();

    /**
     * @param array  $vars Twig variables
     * @param string $xml  Expected XML
     *
     * @dataProvider getMatches
     */
    public function testAssertXml(array $vars, $xml)
    {
        $this->assertXmlStringEqualsXmlString($xml, $this->_template->render($vars));
    }

    /**
     * @param array $callbacks
     *
     * @return stdClass
     */
    protected function _mock(array $callbacks)
    {
        $obj = $this->getMock('stdClass', array_keys($callbacks));
        foreach ($callbacks as $method => $returnValue) {
            $obj
                ->expects($this->any())
                ->method($method)
                ->will($this->returnValue($returnValue));
        }
        return $obj;
    }
}
