<?php
class CoreTest_Container_TestCase extends PHPUnit_Framework_TestCase
{
    /**
     * @param string $name  Component name
     * @param mixed  $value Component
     *
     * @return type
     */
    protected function _mockContainer($name, $value, $params = null)
    {
        // mock the container
        $container = $this->getMock('Core_Yadif_Container');
        if (is_array($params)) {
            $x = 0;
            foreach ($params as $param => $paramValue) {
                $container
                    ->expects($this->at($x++))
                    ->method('bindParam')
                    ->with($this->equalTo(':'. $param), $this->equalTo($paramValue))
                    ->will($this->returnValue($container));
            }
        }
        $container
            ->expects($this->once())
            ->method('getComponent')
            ->with($this->equalTo($name))
            ->will($this->returnValue($value));

        return $container;
    }
}
