<?php
// we're checkin for TESTS_ROOT because we can run some of the tests
// in a separate process via @runInSeparateProcess annotation
if (!defined('TESTS_ROOT')) {
    define('TESTS_ROOT', dirname(__FILE__));
}

if (!defined('FRAMEWORK_ROOT')) {
    define('FRAMEWORK_ROOT', realpath(TESTS_ROOT .'/..'));
}

error_reporting(E_ALL | E_STRICT);
ini_set('display_errors', true);
ini_set('date.timezone', 'Europe/Zagreb');
// TODO: what to do with this?
// mb_internal_encoding('UTF8');
// iconv_set_encoding('internal_encoding', 'UTF-8');
// setlocale(LC_ALL, 'hr_HR.UTF-8');

set_include_path(implode(PATH_SEPARATOR, array(
    FRAMEWORK_ROOT .'/lib',
    TESTS_ROOT     .'/resources/lib',
    TESTS_ROOT     .'/suite/unit/lib',
    TESTS_ROOT     .'/suite/integration/lib',
    get_include_path()
)));

// setup autoloader
require dirname(__DIR__) .'/vendor/autoload.php';

// loading compatibility suite
require_once 'Core/Compat.php';
