<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Xhprof
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category  Core
 * @package   Core_Xhprof
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Xhprof_Profile
{
    const NODE_MAIN = 'main()';

    const PROPERTY_CALL_COUNT        = 'ct';
    const PROPERTY_WALL_TIME         = 'wt';
    const PROPERTY_CPU_TIME          = 'cpu';
    const PROPERTY_MEMORY_USAGE      = 'mu';
    const PROPERTY_PEAK_MEMORY_USAGE = 'pmu';

    protected $_main;

    protected $_data = array();

    public function __construct(array $data = null)
    {
        if (null !== $data) {
            $this->setData($data);
        }
    }

    public function setData(array $data)
    {
        $this->_data = $data;
        return $this;
    }

    public function getData()
    {
        return $this->_data;
    }

    public function getCallCount()
    {
        $main = $this->_extractMain($this->getData());
        return $main[self::PROPERTY_CALL_COUNT];
    }

    public function getWallTime()
    {
        $main = $this->_extractMain($this->getData());
        return $main[self::PROPERTY_WALL_TIME];
    }

    public function getCpuTime()
    {
        $main = $this->_extractMain($this->getData());
        return $main[self::PROPERTY_CPU_TIME];
    }

    public function getMemoryUsage()
    {
        $main = $this->_extractMain($this->getData());
        return $main[self::PROPERTY_MEMORY_USAGE];
    }

    public function getPeakMemoryUsage()
    {
        $main = $this->_extractMain($this->getData());
        return $main[self::PROPERTY_PEAK_MEMORY_USAGE];
    }

    protected function _extractMain(array $data)
    {
        if (!$this->_main) {
            $this->_main = $data[self::NODE_MAIN];
        }
        return $this->_main;
    }
}