<?php
class Core_Validate_Time extends Core_Validate_Abstract
{
    // default error message
    protected $_defaultErrorMessage  = 'Vrijednost nije valjano vrijeme';

    protected $_format = 'H:i:s';

    protected function _isValid($value)
    {
        $format = $this->getFormat();
        $time   = date_parse_from_format($format, $value);

        if ($time['error_count'] > 0 || $time['warning_count'] > 0 || $this->_isInvalidTime($time)) {
            return false;
        }

        return true;
    }

    public function setFormat($format)
    {
        $this->_format = $format;
        return $this;
    }

    public function getFormat()
    {
        return $this->_format;
    }

    protected function _isInvalidTime(array $time)
    {
        // we need atleast hour and minute
        if (!isset($time['hour'])) {
            return false;
        }

        $invalidTime = (
                                  (($time['hour']   < 0 || $time['hour']   > 23))
            || ($time['minute'] && ($time['minute'] < 0 || $time['minute'] > 59))
            || ($time['second'] && ($time['second'] < 0 || $time['second'] > 59))
        );

        return $invalidTime;
    }
}